;----------------------------------------------------------------------------
;    MODULE NAME:   TRYMEDutch.MM
;
;        $Author:   USER "Dennis"  $ (original by CF vd Berg)
;      $Revision:   1.0  $
;          $Date:   26 May 2007 13:58:22  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/TryMeDutch.MM.pvcs  $
;
; DESCRIPTION
; ~~~~~~~~~~~
; This is an example that localizes TryMe.MM for the Dutch language.
; The big effort is of course to translate all the strings in the MSI.
;
; I recommend that you keep translations to MAKEMSI generated text separate
; from others to ensure easy migration to newer versions.
;----------------------------------------------------------------------------



;===========================================
; Set the Dutch language strings and a few other adjustments
;===========================================
#(
    ;--- Define a macro with this specific reserved title: it is automatically called
    ;---    as soon as everything else is done in uisample.mmh, meaning MAKEMSI will
    ;---    not overwrite anything we do here.
    ;--- It has to be defined in the code before the inclusion of the MakeMSI files
    ;---   (here: #include "ME.MMH"), otherwise you'll get a warning that it was defined already.
    #define UISAMPLE_HOOK_FINISHED_UI_UPDATES

    ;--- Set the allowed languages for the MSI
    ;---   The value of ProductLanguage in Property.NLD must be listed in the Value parameter.
    ;---   Values set are: 0 - language neutral, 1033 - english, 1043 - Dutch.
    ;---   Several other language identifiers are listed in the file LanguageIdentifiers.txt.
    <$Summary "TEMPLATE"     Value="Intel;0,1033,1043">

    ;--- Set the CodePage to allow special (language-specific) characters in the dialogs
    ;---   CodePage 1252 is the default, so in this case it doesn't need to be set,
    ;---   but it is added here in case you need a different character set.
    <$CodePage "1252">

    ;--- Direct='N' is necessary to not throw away the previous entries in the table,
    ;---   and only overwrite those needed. (It apparently is slower, though.)
    <$TableImportFromIdt "NLD\MS SDK\*.NLD" DIRECT="N">
    <$TableImportFromIdt "NLD\Mine\*.NLD"   DIRECT="N">

    ;--- adjust the height of the Text field in the Verify Ready dialog, since with
    ;---   the original size, only 2 lines will fit, and our Dutch text needs 3.
    #ifndef UISAMPLE_NEWSIZE_VerifyReadyDlg.Text
        ;--- Must be pre MAKEMSI v07.118 (newer versions already do this) ---
        <$Table "Control">
        #(
            <$Row
                   @Where="Dialog_ = 'VerifyReadyDlg' AND Control = 'Text'"
                   @OK='=1'
                   Height="160"      ;;Previous value = 20
            >
        #)
        <$/Table>
    #endif
#)



;===========================================
; Set the Title and Description of the 'Main' Feature: the 'root' of the feature tree in the Custom Install window.
;===========================================
#define COMPANY_COMPLETE_FEATURE_TITLE          De Software
#define COMPANY_COMPLETE_FEATURE_DESCRIPTION    De complete software van het pakket



;===========================================
; Below here is the relatively unchanged code of the TryMe.MM example
;===========================================


;--- Include MAKEMSI support (with my dutch customisations and MSI branding) ---
#include "ME_Dutch.MMH"         ;;My variation of "ME.MMH" (all of the above could go into this header)

;--- Define default location where file should install and add files --------
<$DirectoryTree Key="INSTALLDIR" Dir="c:\program files\TryMe (makemsi sample)\<$MAKEMSI_MM_BASENAME>" CHANGE="\" PrimaryFolder="Y">
<$Files "TryMe*.*" DestDir="INSTALLDIR">


